#include <stdio.h>
#include <string.h>

#include "mdName.h"

mdName hNameLib;

int main(int argc,char *argv[])
{
	char name[40], *p;
    char *resultsString;
	hNameLib = mdNameCreate();

	//Valid license required
	mdNameSetLicenseString(hNameLib , "License Here");     

    printf("        NAME OBJECT 'C' EXAMPLE\n");
    printf("===========================================\n");
	printf("            Build Number: %s \n", mdNameGetBuildNumber(hNameLib));

	// Point to Name Object data files 
	mdNameSetPathToNameFiles(hNameLib, "C:\\Program Files\\Melissa DATA\\DQT\\Data");
	
	// Initialize 
	if(mdNameInitializeDataFiles(hNameLib) != 0)
	{
		printf("Initialization Error : %s \n", mdNameGetInitializeErrorString(hNameLib));
		return 0;
	}

	// Get Initialization properties
	printf("           Database Date: %s \n", mdNameGetDatabaseDate(hNameLib));
	printf("Database Expiration Date: %s \n", mdNameGetDatabaseExpirationDate(hNameLib));
	printf(" License Expiration Date: %s \n", mdNameGetLicenseExpirationDate(hNameLib));


	//Set Options
	mdNameSetPrimaryNameHint(hNameLib,ProbablyFull);
	mdNameSetFirstNameSpellingCorrection(hNameLib,1);

	printf("\nEnter Name: ");
	fgets(name, sizeof name, stdin);
	if((p = strchr(name, '\n')) != NULL) 
		*p = '\0';

	//Input a name and Parse it
	mdNameSetFullName(hNameLib,name);
	mdNameParse(hNameLib);

	// get the returnes Output properties
	printf("\n");
	printf("-------------------------------------------\n");
	printf("                 Results                   \n");
	printf("-------------------------------------------\n");
	printf("      Prefix: %s \n", mdNameGetPrefix(hNameLib));
	printf("  First Name: %s \n", mdNameGetFirstName(hNameLib));
	printf(" Middle Name: %s \n", mdNameGetMiddleName(hNameLib));
	printf("   Last Name: %s \n", mdNameGetLastName(hNameLib));
	printf("      Suffix: %s \n", mdNameGetSuffix(hNameLib));
	printf("      Gender: %s \n", mdNameGetGender(hNameLib));
	printf("     Prefix2: %s \n", mdNameGetPrefix2(hNameLib));
	printf(" First Name2: %s \n", mdNameGetFirstName2(hNameLib));
	printf("Middle Name2: %s \n", mdNameGetMiddleName2(hNameLib));
	printf("  Last Name2: %s \n", mdNameGetLastName2(hNameLib));
	printf("     Suffix2: %s \n", mdNameGetSuffix2(hNameLib));
	printf("     Gender2: %s \n", mdNameGetGender2(hNameLib));
	printf("  Salutation: %s \n", mdNameGetSalutation(hNameLib));

	//Parse results are returned as a delimited string, so we need to parse them...
	resultsString = mdNameGetResults(hNameLib);
    printf("\nResults Codes...\n");
    if (strstr(resultsString,"NS01")!=0)
	    printf("NS01: There were no Errors.\n");
	if (strstr(resultsString,"NS03")!=0)
        printf("NS03: The spelling of the FirstName field was corrected.\n");
    if (strstr(resultsString,"NS04")!=0)
        printf("NS04: The spelling of the FirstName2 field was corrected.\n");
	
    if (strstr(resultsString,"NS02")!=0)
    {
        printf("NS02: Name Parse found an Error...\n");
        if (strstr(resultsString,"NE01")!=0)
           printf("NE01: Two names were detected but the FullName string was not in a recognized format.\n");
        if (strstr(resultsString,"NE02")!=0)
           printf("NE02: Multiple first names  could not accurately genderize.\n");

        if (strstr(resultsString,"NE03")!=0)
           printf("NE03: A vulgarity was detected in the name.\n");
        if (strstr(resultsString,"NE04")!=0)
           printf("NE04: The name contained words found on the list of nuisance names (such as Mickey Mouse).\n");
        if (strstr(resultsString,"NE05")!=0)
           printf("NE05: The name contained words normally found in a company name.\n");
        if (strstr(resultsString,"NE06")!=0)
           printf("NE06: The named contained a non-alphabetic character.\n");
	}

    // destroy the object
	mdNameDestroy(hNameLib);
}
